package org.msh.tb.bd.tbforms.dhis2;

import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.tbforms.dhis2.data.AuthResponse;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.dhis2.data.DataValueResponse;
import org.msh.utils.JsonUtils;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;

/**
 * Created by Mauricio on 06/02/2017.
 * Service that export information to DHIS2
 */
@Name("dHIS2DataExportService")
public class DHIS2DataExportService extends DHIS2RequestService {

    private final String API_URL = "/api/dataValueSets";

    /**
     * Send a request to DHIS2 containing Data Set values on payload
     * @param credentials
     * @param payLoad
     * @return
     * @throws IOException
     */
    public DataValueResponse sendData(AuthResponse credentials, DataValuePayload payLoad) throws IOException {

        if (credentials == null || payLoad == null) {
            throw new RuntimeException("Credentials and Data Value Payload must not be null.");
        }

        // mount authorization String
        String authorization = "Bearer " + credentials.getAccess_token();

        HttpURLConnection conn = null;
        DataValueResponse ret = null;

        try {
            // get connection
            conn = super.getPostConnection(API_URL, null, authorization);

            // Parse payLoad
            String input = JsonUtils.objectToJSONString(payLoad, false);

            OutputStream os = conn.getOutputStream();
            os.write(input.getBytes());
            os.flush();

            // request
            checkHttpCode(conn.getResponseCode());

            // read response
            ret = JsonUtils.parse(conn.getInputStream(), DataValueResponse.class);

        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }

        return ret;
    }
}
